package service;


public abstract class ComposedTransition extends Transition {
	/**
	 * Creates a new composed action
	 * @param name the name that identifies the action.
	 * @param ts the transition system associated to the action
	 * @param from the source state of the composed action
	 * @param to the target state of the composed action
	 */	
	public ComposedTransition(String name, TransitionSystem<? extends State,? extends Transition> ts,ComposedState from,ComposedState to){
		super(name);
	}
	
	
	/**
	 * Returns the transition system associated with the composed action
	 * @return the transition system described above.
	 */
	public abstract TransitionSystem<? extends State,? extends Transition> getService();
	/**
	 * This method returns the hashCode of the composed action
	 * @return The result contains the hashCode of the composed action
	 */
	public abstract int hashCode();
	/**
	 * This method compares a composed action with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a ComposedAction and the name,the target state and the source state of the two ComposedAction are equals.
	 */
	
	public abstract boolean equals(Object obj);
	/** This method returns the source state of the action
	 * @return the source state of the action
	 */
	public abstract ComposedState getStateFrom();
	/** This method returns the target state of the action
	 * @return the target state of the action
	 */
	public abstract ComposedState getStateTo();

}


